/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.portal;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class EAPShaUtil {
    public static String SHA(String strText, String strType) {
        String string = null;
        if (strText != null && strText.length() > 0) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(strType);
                messageDigest.update(strText.getBytes(StandardCharsets.UTF_8));
                byte[] byArray = messageDigest.digest();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    String string2 = Integer.toHexString(0xFF & byArray[i2]);
                    if (string2.length() == 1) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return string;
    }

    public String SHA256(String strText) {
        return EAPShaUtil.SHA(strText, "SHA-256");
    }

    public String SHA512(String strText) {
        return EAPShaUtil.SHA(strText, "SHA-512");
    }

    public static byte[] SHABytes(String strText, String strType) {
        byte[] byArray = null;
        if (strText != null && strText.length() > 0) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(strType);
                messageDigest.update(strText.getBytes(StandardCharsets.UTF_8));
                byArray = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return byArray;
    }

    public static byte[] SHA256Bytes(String strText) {
        return EAPShaUtil.SHABytes(strText, "SHA-256");
    }

    public byte[] SHA512Bytes(String strText) {
        return EAPShaUtil.SHABytes(strText, "SHA-512");
    }

    public static String HashMacSha256(String rawString, String secretKey) {
        Mac mac = null;
        SecretKeySpec secretKeySpec = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
            secretKeySpec = new SecretKeySpec(secretKey.getBytes("UTF-8"), "HmacSHA256");
            mac.init(secretKeySpec);
            mac.update(rawString.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encode(mac.doFinal());
        return string;
    }

    public static String HashMacSha1(String rawString, String secretKey) {
        Mac mac = null;
        SecretKeySpec secretKeySpec = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            secretKeySpec = new SecretKeySpec(secretKey.getBytes("UTF-8"), "HmacSHA1");
            mac.init(secretKeySpec);
            mac.update(rawString.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string = bASE64Encoder.encode(mac.doFinal());
        return string;
    }
}

